<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CWidgetsWidgetMediaWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "18",
		"name"	=> "Media w/ Carousel",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		$items = $this->module->GetStaticItems($widget);

		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {
			switch ($val["item_type"]) {
				//image
				case "1":				
					$items[$key]["tn"] = "upload/widgets/static/tn_{$val[item_id]}.jpg";
					$items[$key]["source"] = "upload/widgets/static/{$val[item_id]}.jpg";
					$items[$key]["icon"] = $this->tpl->BlockReplace("Image");
				break;

				//youtube
				case "2":
					$items[$key]["tn"] = "https://img.youtube.com/vi/" . $val["item_youtube"] . "/maxresdefault.jpg";
					$items[$key]["source"] = "https://www.youtube.com/watch?v=" . $val["item_youtube"];
					$items[$key]["icon"] = $this->tpl->BlockReplace("Video");
				break;

				//vimeo
				case "3":

					$info = CHTTP::NewInstance()
						->Get("https://vimeo.com/api/v2/video/" . $val["item_vimeo"] . ".json")
						->JSon(); 

					if (is_array($info["0"]) && $info["0"]["thumbnail_large"]) {
						$items[$key]["tn"] = $info["0"]["thumbnail_large"];
					}
					
					$items[$key]["source"] = "https://www.vimeo.com/" . $val["item_vimeo"];
					$items[$key]["icon"] = $this->tpl->BlockReplace("Video");
				break;
			}									
		}		


		return $this->tpl->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->Table(
					$this->tpl , 
					"" , 
					$items
				),
				"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),
			),
			$widget["settings"],
			$widget
		);	

	}
			

}


?>